import logging
import queue
import re
import sys
import threading
import time

from core.dnw import Dnw
from core.scan import GetUsbSerialPorts
from serial.serialutil import SerialException

def fileSendLoop(port, fileList, stop_on_fail = '1', retry_max = 50):
    protocol = Dnw(port)
    workSequence = 0

    if protocol.open() is False:
        pass
    else:
        protocol.putc(b'\x0a')  # to get fast response
        ApModel, fileNameToSend = protocol.getReqFromDevice()
        while True:
            try:
                # get request, find requested file on cfg.fileList (dict) then send.

                if fileNameToSend is None:
                    break

                filePath = fileList.get(fileNameToSend)
                if filePath is None:
                    logging.debug('*There is no {} in config.'.format(fileNameToSend))
                    protocol.sendStopPattern()
                    continue

                logging.debug('[{}::{}] {}'.format(port, workSequence, filePath))


                ShowProgress = False
                refreshLineOnProgress = True

                return_value, msgLeft = protocol.sendOverDnw(ApModel, fileNameToSend, filePath, ShowProgress, refreshLineOnProgress)
                """
                #if file transfer need thread.
                que = queue.Queue()
                workThread = threading.Thread(target=lambda q, arg1, arg2, arg3: q.put(protocol.sendOverDnw(arg1, arg2, arg3)),
                                              args=(que, filePath, ShowProgress, refreshLineOnProgress))
                workThread.daemon = True
                workThread.start()

                while workThread.is_alive():
                    #sys.stdout.write('\rsent: ' + str(protocol.getProgress()) + '%')
                    pass

                workThread.join()
                return_value = que.get()
                """

                logging.debug('[{}::{}] Transfer Status:{}'.format(port, workSequence, return_value))
                fileNameToSend = None

                if msgLeft is not None:
                    partial1 = protocol.ser.read_until().decode()  # buy little time
                    partial2 = protocol.ser.read_all().decode()  # get all it has.
                    msgDecoded = msgLeft + partial1 + partial2

                    # check if msg contains request information
                    # get all the message until it request next
                    try:
                        retry_cnt=0
                        while True:
                            if msgDecoded is None:
                                msgDecoded = protocol.ser.readline().decode()
                                retry_cnt+=1
                                if (retry_cnt >= retry_max):
                                    raise Exception('retry too many times')

                            if msgDecoded is not None:
                                logging.debug('retry count: {}, msgDecoded: "{}"'.format(retry_cnt, msgDecoded))

                            m = re.compile('([\s\S]*)eub:req:'+ApModel+':(.*)\n').match(msgDecoded)

                            if m == None:
                                msgDecoded = None
                            else:
                                fileNameToSend = m.group(2)
                                break
                    except SerialException as e:
                        break
                    except Exception as e:
                        logging.debug('Exception: {}'.format(e), exc_info=True)
                        break


                if stop_on_fail=='1' and return_value == False:
                    break

                workSequence += 1
            except Exception as e:
                logging.debug('Exception: {}'.format(e), exc_info=True)
                break

    protocol.close()
    logging.debug('*End {} work'.format(port))
    return


def scanAndSelect(cfg):
    selectedPort = None
    spinnerCnt = 0
    spinnerSymbol = ['/', '-', '\\', '|']

    logging.debug('Exynos USB booting tool')

    while True:
        opened_ports = GetUsbSerialPorts()

        if len(opened_ports) == 0:
            sys.stdout.write('\rScanning Exynos' + ' ' + spinnerSymbol[spinnerCnt])
            time.sleep(0.5)
            spinnerCnt = (spinnerCnt + 1) % len(spinnerSymbol)
            continue

        if cfg.option_force_device is not None:
            if cfg.option_force_device in opened_ports:
                selectedPort = cfg.option_force_device
                logging.info('\n{} port found.'.format(cfg.option_force_device))
                if cfg.option_auto_start == '0':
                    logging.info('*press enter to start')
                    input()
                else:
                    logging.debug('*auto start')
                break
            else:
                sys.stdout.write('\rWaiting Exynos on port '+cfg.option_force_device + '(option_force_device)' + ' '
                                 + spinnerSymbol[spinnerCnt])
                time.sleep(0.5)
                spinnerCnt = (spinnerCnt + 1) % len(spinnerSymbol)
                continue

        if cfg.option_auto_start == '1':
            break

        logging.info('Press enter to refresh device list')
        logging.info('Press x to exit')
        cnt = 0
        for port in opened_ports:
            cnt += 1
            logging.info('{} > {}'.format(cnt, port))

        logging.info('Select device: ')
        x = input()
        x = x.strip()

        if x == '':
            sys.stdout.write('\rscan again')
            continue
        elif x == 'x':
            exit(0)
        else:
            try:
                x = int(x)
            except Exception as e:
                logging.debug('Exception: {}'.format(e), exc_info=True)
                x = -1
            if (x > 0) and (x <= len(opened_ports)):
                logging.info('{} selected.'.format(x))
                selectedPort = opened_ports[x - 1]
                break
            else:
                logging.info('Wrong input.')

    return selectedPort, opened_ports
