import logging
from serial.tools.list_ports import comports

"""

---  4: COM21                'USB 직렬 장치(COM21)' desc should have USB string

exynos_usb_booting::e98200000d5f5e800b75
                                              eub:req:bl1
                                                         CC
"""



def GetUsbSerialPorts():
    #logging.debug('\n--- Available ports:')
    ports = []
    arranged = enumerate(sorted(comports()), 1)
    for n, A in arranged:
        #logging.debug('--- {0:2}: {1:20} / {2} / {3} / {4} / {5} / {6} / {7}'.format(n,  A.device, A.description, A.hwid, A.interface, A.manufacturer, A.product, A.serial_number))  # USB VID:PID=04E8:1100 <- exynos
        if 'VID:PID=18D1:4F00' in A.hwid:
            ports.append(A.device)
            #ports.append((A.device.strip(), A.hwid.strip()))
    return ports

def GetPorts_all():
    logging.debug('\n--- Available ports:')
    ports = []
    arranged = enumerate(sorted(comports()), 1)
    for n, A in arranged:
        logging.debug('--- {0:2}: {1:10} / {2} / {3} / {4} / {5} / {6} / {7}'.format(n,  A.device, A.description, A.hwid, A.interface, A.manufacturer, A.product, A.serial_number))  # USB VID:PID=04E8:1100 <- exynos
        ports.append(A.device)
        #ports.append((A.device.strip(), A.hwid.strip()))
    return ports

if __name__ == '__main__':
    GetPorts_all()
