#!/usr/bin/env python3
# -*- coding: utf-8 -*-

from collections import OrderedDict
import logging
import os
import re

class ProgramConfig:
    filePath = None
    lineProcessed = list()
    fileList = OrderedDict()
    lastkeyToSend = ''
    executedPath = None

    option_force_device = None
    option_auto_start = '1'
    option_pause_before_terminate = '1'
    option_program_loop = '0'
    option_stop_program_on_fail_response = '1'

    def __init__(self, filePath):
        self.filePath = filePath
        return

    def parse(self):
        try:
            file = open(self.filePath, 'r', encoding='UTF8')
            lines = file.readlines()
            file.close()
            #logging.debug(lines)
        except Exception as e:
            logging.debug('Exception: {}'.format(e), exc_info=True)
            return False

        # remove comment
        for line in lines:
            remvd = re.sub(r'[;#].*', '', line)
            remvd = remvd.rstrip('\n')
            remvd = remvd.strip()# whitespace trim

            if remvd == '':
                continue
            self.lineProcessed.append(remvd)
            #logging.debug(remvd)

        for a in self.lineProcessed:
            m = re.compile('option_force_device\\s*=\\s*(.*)\\s*').match(a)
            if m is not None:
                tmp = m.group(1).strip()
                logging.debug('option_force_device ' + tmp)
                self.option_force_device = tmp
                continue

            m = re.compile('option_auto_start\\s*=\\s*(.*)\\s*').match(a)
            if m is not None:
                tmp = m.group(1).strip()
                logging.debug('option_auto_start ' + tmp)
                self.option_auto_start = tmp
                continue

            m = re.compile('option_pause_before_terminate\\s*=\\s*(.*)\\s*').match(a)
            if m is not None:
                tmp = m.group(1).strip()
                logging.debug('option_pause_before_terminate ' + tmp)
                self.option_pause_before_terminate = tmp
                continue

            m = re.compile('option_program_loop\\s*=\\s*(.*)\\s*').match(a)
            if m is not None:
                tmp = m.group(1).strip()
                logging.debug('option_program_loop ' + tmp)
                self.option_program_loop = tmp
                continue

            m = re.compile('option_stop_program_on_fail_response\\s*=\\s*(.*)\\s*').match(a)
            if m is not None:
                tmp = m.group(1).strip()
                logging.debug('option_stop_program_on_fail_response ' + tmp)
                self.option_stop_program_on_fail_response = tmp
                continue

            m = re.compile('send\\s+(.*)\\s+(.*)\\s*').match(a)
            if m is not None:
                key = m.group(1).strip()
                value = m.group(2).strip()
                logging.debug('{} {}'.format(key, value))

                if '..' + os.sep in value or '.' + os.sep:
                    dirname = os.path.dirname(self.filePath)
                    value = os.path.join(dirname, value)


                self.fileList[key] = value
                self.lastkeyToSend = key
                continue

        return True

#unit module test
if __name__ == '__main__':
    configFile = 'test_binary/usb_booting.txt'
    cfg = ProgramConfig(configFile)
    cfg.parse()
