# -*- coding: utf-8 -*-

import logging
from pathlib import Path
import platform
import re
import sys
import time

import serial


"""
Example
eub:req:e9820:bl1\nC

eub:ack:e9820:bl1\n

eub:nak:e9820:bl1\nC
"""


class Dnw:
    port = None
    ser = serial.Serial()
    dnw_target_addr = b'\x1b\x44\x4E\x57'#0x1b 'D''N''W'
    dnw_crc = b'\xFF\xFF'

    progressPercent = 0

    def __init__(self, port):
        self.port = port

    def open(self):
        try:
            self.ser = serial.Serial(port=self.port, timeout=0.5)
        except (OSError, serial.SerialException) as e:
            logging.debug('Exception: {}, channel in use, abort.'.format(e), exc_info=True)
            return False
        return True
    def close(self):
        self.ser.close()
        return

    def getc(self, size, timeoutsec=3):

        toutCnt = 0
        toutCntMax = timeoutsec*10
        while self.ser.in_waiting == 0:
            if toutCnt > toutCntMax:  # wait 3s for at least 1byte input
                logging.debug('timeout, No input from device')
                return None
            else:
                toutCnt += 1
                time.sleep(0.1)
            pass
        ret = self.ser.read(size)
        return ret or None

    def read_all_in_buffer(self):

        ret = self.ser.read_all()
        return ret

    def putc(self, data, timeout=0):
        ret = self.ser.write(data)
        self.ser.flush()
        #    sleep(0.1)
        return ret or None

    def getReqFromDevice(self):

        msgRecved = []

        reqBin = None
        for atry in range(2):
            #recvd = self.getc(40)
            head = self.getc(5)  # some LF can com first.
            recvd = self.ser.read_until()  # read until LF
            if recvd is None:
                return None

            decoded = head.decode() + recvd.decode()
            msgRecved.append(decoded)
            #logging.debug('getReqFromDevice('+str(atry)+')::"'+decoded+'"')

            m = re.compile('[\s\S]*q:([a-z0-9]+):(.*)\n').match(decoded)
            if m is not None:
                ApModel = m.group(1)
                reqBin = m.group(2)
                break
            else:
                #retry, normal msg can come to here.
                """
                try:
                    logging.debug(decoded)
                except Exception as ex:
                    logging.debug(ex, exc_info=True)
                """
                continue

        if reqBin is None:
            logging.debug('*error* getReqFromDevice::for debug, got msg')
            for aline in msgRecved:
                logging.debug('"'+aline+'"')
                logging.debug('getReqFromDevice::end')

        return ApModel, reqBin

    def getProgress(self):
        return self.progressPercent

    def sendStopPattern(self):
        stop_data = [ 0x1b, 0x44, 0x4e, 0x57, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00 ]
        self.ser.write(stop_data)
        self.ser.flush()
        return

    def sendOverDnw(self, ApModel, fileNameToSend, fileToSend, ShowSentProgress=False, refreshLineOnProgress=True):

        self.progressPercent = 0

        file = Path(fileToSend)
        if not file.is_file():
            logging.debug('No File:' + fileToSend)
            return False, None

        try:

            #logging.debug('sendOverDnw::open::'+fileToSend)
            file = open(fileToSend, 'rb')
            file_content = file.read()
        except Exception as e:
            logging.debug('Exception: {}'.format(e), exc_info=True)
            return False, None

        dnw_form = bytearray()
        dnw_size = len(file_content) + 4 + 4 + 2

        dnw_form.extend(self.dnw_target_addr)
        dnw_form.extend(dnw_size.to_bytes(4, byteorder='little'))
        dnw_form.extend(bytearray(file_content))
        dnw_form.extend(bytearray(self.dnw_crc))

        # loop
        runningSystem = platform.system()
        if runningSystem == 'Windows':
            unitsizebyte = 10240
        elif runningSystem == 'Darwin':
            unitsizebyte = 384
        else:  # Linux
            unitsizebyte = 512

        loop = int(dnw_size / unitsizebyte)
        modulus = dnw_size % unitsizebyte
        if modulus != 0:
            loop += 1
        #logging.debug('[{}] file: {}, send buffer: {} bytes, total loop: {}'.format(self.port, fileToSend, unitsizebyte, loop))
        try:
            for index in range(loop):
                unitbuffer = dnw_form[0 + unitsizebyte * index: unitsizebyte + unitsizebyte * index]
                # print_binary_buffer_part(unitbuffer, 0, len(unitbuffer))
                self.putc(unitbuffer)
                self.progressPercent = int((index + 1) / loop * 100)
                if ShowSentProgress == True:
                    if refreshLineOnProgress == True:
                            sys.stdout.write('\rsent: ' + str(self.progressPercent) + '%')
                    else:
                        logging.debug('sent: ' + str(self.progressPercent) + '%')
        except Exception as e:
            logging.debug('Exception: {}'.format(e), exc_info=True)

        if ShowSentProgress == True and refreshLineOnProgress == True:
            logging.debug('')

        recvd = self.getc(400)
        decoded = recvd.decode()

        """  #  This cannot get immediate failure message after ack.
        head = self.getc(5)  # some LF can com first.
        recvd = self.ser.read_until()  # read until LF
        decoded = head.decode() + recvd.decode()
        """
        #logging.debug('debug:'+decoded+'//')
        #logging.debug('len:'+str(len(decoded)))

        m = re.compile('[\s\S]*eub:([acn]+k):'+ApModel+':'+fileNameToSend+'\n'+'(.*)').match(decoded)
        if m == None:
            #logging.debug('\n*try another parsing:"'+decoded+'"')
            #m = re.compile('[\s\S]*C\neub:([acn]+k)').match(decoded)
            if m == None:
                logging.debug('\n*sendOverDnw::error on response:"' + decoded + '"')
                recvd = self.getc(40)
                decoded = recvd.decode()
                logging.debug('\n*sendOverDnw::get One more string for debug:"'+decoded+'"')
                return False, None

        resp = m.group(1)  # ack or nak
        msgLeft = m.group(2)
        #logging.debug('response:'+resp)
        #logging.debug('DEBUG:msgLeft:'+msgLeft+'//')
        """
        if msgLeft is not None:
            logging.debug(msgLeft)
            logging.debug(self.ser.read_until())
            logging.debug(self.ser.read_all())
        """


        if resp == 'ack':
            return True, msgLeft
        else:
            return False, msgLeft

def print_binary_buffer_part(self, buffer, offset, size):
    reline = 0

    for i in range(offset, offset + size, 1):
        logging.debug('{0:02X} '.format(buffer[i]))
        reline += 1
        if reline == 16:
            reline = 0
    return
